/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapping;

import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import technology.rocketjump.undermount.mapping.model.TiledMap;
import technology.rocketjump.undermount.mapping.tile.CompassDirection;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.mapping.tile.MapVertex;

public class OutdoorLightProcessor {
    private final float MAX_LIGHT_PROPAGATION_DISTANCE = 12.5f;

    public void propagateLightFromMapVertex(TiledMap map, MapVertex vertex, float previousLuminosity) {
        if (this.hasWallInAbsoluteDirection(CompassDirection.NORTH_WEST, map, vertex) && this.hasWallInAbsoluteDirection(CompassDirection.SOUTH_EAST, map, vertex) || this.hasWallInAbsoluteDirection(CompassDirection.NORTH_EAST, map, vertex) && this.hasWallInAbsoluteDirection(CompassDirection.SOUTH_WEST, map, vertex)) {
            return;
        }
        for (CompassDirection direction : CompassDirection.values()) {
            float propagatedLight;
            MapVertex neighbourVertex;
            if (this.hasWallInDirection(direction, map, vertex) || (neighbourVertex = map.getVertex(vertex.getVertexX() + direction.getXOffset(), vertex.getVertexY() + direction.getYOffset())) == null || !((propagatedLight = this.calculateFalloff(previousLuminosity, direction.distance())) > neighbourVertex.getOutsideLightAmount())) continue;
            neighbourVertex.setOutsideLightAmount(propagatedLight);
            this.propagateLightFromMapVertex(map, neighbourVertex, propagatedLight);
        }
    }

    public void propagateDarknessFromVertex(TiledMap map, MapVertex currentVertex) {
        LinkedList<VertexToVisit> toVisit = new LinkedList<VertexToVisit>();
        LinkedList<MapVertex> endpoints = new LinkedList<MapVertex>();
        HashSet<MapVertex> visited = new HashSet<MapVertex>();
        visited.add(currentVertex);
        currentVertex.setOutsideLightAmount(0.0f);
        for (CompassDirection direction : CompassDirection.values()) {
            MapVertex neighbourVertex;
            if (this.hasWallInDirection(direction, map, currentVertex) || (neighbourVertex = map.getVertex(currentVertex.getVertexX() + direction.getXOffset(), currentVertex.getVertexY() + direction.getYOffset())) == null) continue;
            toVisit.add(new VertexToVisit(neighbourVertex, direction.distance()));
            this.propagateDarknessFromVertexInner(map, neighbourVertex, direction.distance(), toVisit, endpoints, visited);
        }
        while (!toVisit.isEmpty()) {
            VertexToVisit vertexToVisit = (VertexToVisit)toVisit.pop();
            this.propagateDarknessFromVertexInner(map, vertexToVisit.vertex, vertexToVisit.distanceCovered, toVisit, endpoints, visited);
        }
        for (MapVertex endpoint : endpoints) {
            float currentLuminosity = endpoint.getOutsideLightAmount();
            this.propagateLightFromMapVertex(map, endpoint, currentLuminosity);
        }
    }

    private void propagateDarknessFromVertexInner(TiledMap map, MapVertex currentVertex, float distanceTravelled, Deque<VertexToVisit> toVisit, List<MapVertex> endpoints, Set<MapVertex> visited) {
        if (visited.contains(currentVertex)) {
            return;
        }
        if (!(currentVertex.getOutsideLightAmount() < 0.1f)) {
            if (currentVertex.getOutsideLightAmount() >= 0.99f) {
                endpoints.add(currentVertex);
            } else if (distanceTravelled >= 12.5f) {
                endpoints.add(currentVertex);
            } else {
                currentVertex.setOutsideLightAmount(0.0f);
                for (CompassDirection direction : CompassDirection.values()) {
                    MapVertex neighbourVertex;
                    if (this.hasWallInDirection(direction, map, currentVertex) || (neighbourVertex = map.getVertex(currentVertex.getVertexX() + direction.getXOffset(), currentVertex.getVertexY() + direction.getYOffset())) == null) continue;
                    toVisit.add(new VertexToVisit(neighbourVertex, distanceTravelled + direction.distance()));
                }
            }
        }
        visited.add(currentVertex);
    }

    private boolean hasWallInDirection(CompassDirection direction, TiledMap map, MapVertex vertex) {
        switch (direction) {
            case NORTH_WEST: {
                return this.hasWallInAbsoluteDirection(CompassDirection.NORTH_WEST, map, vertex) || this.hasWallInAbsoluteDirection(CompassDirection.NORTH_EAST, map, vertex) && this.hasWallInAbsoluteDirection(CompassDirection.SOUTH_WEST, map, vertex);
            }
            case NORTH_EAST: {
                return this.hasWallInAbsoluteDirection(CompassDirection.NORTH_EAST, map, vertex) || this.hasWallInAbsoluteDirection(CompassDirection.NORTH_WEST, map, vertex) && this.hasWallInAbsoluteDirection(CompassDirection.SOUTH_EAST, map, vertex);
            }
            case SOUTH_WEST: {
                return this.hasWallInAbsoluteDirection(CompassDirection.SOUTH_WEST, map, vertex) || this.hasWallInAbsoluteDirection(CompassDirection.NORTH_WEST, map, vertex) && this.hasWallInAbsoluteDirection(CompassDirection.SOUTH_EAST, map, vertex);
            }
            case SOUTH_EAST: {
                return this.hasWallInAbsoluteDirection(CompassDirection.SOUTH_EAST, map, vertex) || this.hasWallInAbsoluteDirection(CompassDirection.SOUTH_WEST, map, vertex) && this.hasWallInAbsoluteDirection(CompassDirection.NORTH_EAST, map, vertex);
            }
            case NORTH: {
                return this.hasWallInAbsoluteDirection(CompassDirection.NORTH_WEST, map, vertex) && this.hasWallInAbsoluteDirection(CompassDirection.NORTH_EAST, map, vertex);
            }
            case EAST: {
                return this.hasWallInAbsoluteDirection(CompassDirection.NORTH_EAST, map, vertex) && this.hasWallInAbsoluteDirection(CompassDirection.SOUTH_EAST, map, vertex);
            }
            case SOUTH: {
                return this.hasWallInAbsoluteDirection(CompassDirection.SOUTH_WEST, map, vertex) && this.hasWallInAbsoluteDirection(CompassDirection.SOUTH_EAST, map, vertex);
            }
        }
        return this.hasWallInAbsoluteDirection(CompassDirection.SOUTH_WEST, map, vertex) && this.hasWallInAbsoluteDirection(CompassDirection.NORTH_WEST, map, vertex);
    }

    private boolean hasWallInAbsoluteDirection(CompassDirection direction, TiledMap map, MapVertex vertex) {
        boolean hasWall = true;
        MapTile cell = map.getTile(vertex, direction);
        if (cell != null) {
            hasWall = cell.hasWall();
        }
        return hasWall;
    }

    float calculateFalloff(float previousLuminsoity, float distance) {
        float newLuminosity = previousLuminsoity - distance * (previousLuminsoity * 0.15f);
        if (newLuminosity < 0.15f) {
            newLuminosity = 0.0f;
        }
        return newLuminosity;
    }

    private static class VertexToVisit {
        public final MapVertex vertex;
        public final float distanceCovered;

        private VertexToVisit(MapVertex vertex, float distanceCovered) {
            this.vertex = vertex;
            this.distanceCovered = distanceCovered;
        }
    }
}

